--[[---------------------------------------------------------------------------
	Chocolatier Two Name Entry Dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local name = gDialogTable.name
local xLeft = kCenter-ui.devButtonW/2
local xRight = kCenter+ui.devButtonW/2

MakeDialog
{
	Frame
	{
		x=kCenter,y=kCenter,w=ui.screenWidth/2,h=150,color=DialogColor,
		
		Text { x=0,y=20,w=kMax,h=kMax, flags=kHAlignCenter + kVAlignTop, label="entername" },
		
		Bitmap { x=kCenter,y=50,image="control/name_entry_field",
			TextEdit { x=2,y=2,w=kMax-4,h=kMax-4, name="namefield", label=name,
				font = dialogFont,
				length=20, ignore=kIgnoreBadNameChars, },
		},
		
		TextButton { x=xLeft,y=100, name="enterok", label="ok", default=true,
			command = function()
				local n = GetLabel("namefield")
				if IsNameInUse(n) then
					DisplayDialog { "ui/okdialog.lua", body="nameinuse" }
					SetFocus("namefield")
				else
					CloseWindow(GetLabel("namefield"))
				end
			end,
		},
		
		TextButton { x=xRight,y=100, name="cancel", label="cancel",
			command = function()
				CloseWindow(nil)
			end,
		},
	}
}

SetFocus("namefield")
